# 🔐 Sistema de Licencias Independiente - Grupos Digitales

## 📋 Descripción
Sistema minimalista y robusto para gestión de licencias de software, diseñado para reemplazar WHMCS en la verificación de licencias.

## 🏗️ Características

### ✅ **Panel de Administración**
- Login seguro con sesiones
- Dashboard con estadísticas
- Gestión de clientes
- Gestión de licencias
- Logs de verificaciones
- Configuración del sistema

### ✅ **API de Verificación**
- Endpoint RESTful para verificación de licencias
- Soporte para múltiples formatos de respuesta (JSON, XML, pipes)
- Sistema de claves locales para funcionamiento offline
- Rate limiting y seguridad

### ✅ **Gestión de Clientes**
- CRUD completo de clientes
- Múltiples licencias por cliente
- Dominios autorizados por licencia
- Estados de licencia (Activa, Suspendida, Expirada)

### ✅ **Seguridad**
- Autenticación por tokens
- Validación de dominios
- Logs de auditoría
- Protección contra ataques

## 📁 Estructura de Archivos

```
license-system/
├── api/
│   ├── verify.php          # Endpoint principal de verificación
│   ├── config.php          # Configuración de la API
│   └── functions.php       # Funciones auxiliares
├── admin/
│   ├── index.php           # Dashboard principal
│   ├── login.php           # Sistema de login
│   ├── clients.php         # Gestión de clientes
│   ├── licenses.php        # Gestión de licencias
│   ├── logs.php            # Visualización de logs
│   └── logout.php          # Cerrar sesión
├── assets/
│   ├── css/
│   │   └── style.css       # Estilos del sistema
│   └── js/
│       └── app.js          # JavaScript del sistema
├── database/
│   └── schema.sql          # Estructura de la base de datos
├── install.php             # Instalador del sistema
└── README.md               # Esta documentación
```

## 🗄️ Estructura de Base de Datos

### Tabla: `clients`
- id, name, email, company, created_at, updated_at

### Tabla: `licenses`
- id, client_id, license_key, product_name, status, domains, created_at, expires_at

### Tabla: `license_logs`
- id, license_key, domain, ip, status, response, created_at

### Tabla: `admin_users`
- id, username, password, created_at, last_login

### Tabla: `settings`
- setting_key, setting_value

## 🚀 Instalación

1. Subir archivos a `https://repo.gruposdigitales.com/`
2. Acceder a `https://repo.gruposdigitales.com/install.php`
3. Seguir el asistente de instalación
4. Configurar la base de datos
5. Crear usuario administrador
6. **¡Eliminar install.php!**

## 📡 Uso de la API

### Verificación de Licencia
```
POST https://repo.gruposdigitales.com/api/verify.php

Parámetros:
- license_key: La clave de licencia a verificar
- domain: Dominio desde donde se hace la verificación
- product: Nombre del producto (opcional)
```

### Respuesta JSON
```json
{
    "status": "Active",
    "message": "Licencia válida",
    "license_key": "gd-12345678",
    "client": "Cliente Ejemplo",
    "expires_at": "2025-12-31",
    "localkey": "base64_encoded_local_key"
}
```

### Respuesta XML (Compatibilidad)
```xml
<license>
    <status>Active</status>
    <message>Licencia válida</message>
    <license_key>gd-12345678</license_key>
    <client>Cliente Ejemplo</client>
    <expires_at>2025-12-31</expires_at>
    <localkey>base64_encoded_local_key</localkey>
</license>
```

## 🔧 Configuración

El sistema se configura automáticamente durante la instalación, pero se puede modificar posteriormente desde el panel de administración.

## 🔒 Seguridad

- Passwords hasheados con PHP `password_hash()`
- Sesiones seguras
- Validación de entrada en todos los endpoints
- Logs de auditoría completos
- Rate limiting en la API

## 📞 Soporte

Sistema desarrollado para Grupos Digitales
Instalación en: https://repo.gruposdigitales.com/ 