<nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'index.php' ? 'active' : '' ?>" href="index.php">
                    <i class="fas fa-tachometer-alt me-2"></i>
                    Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'clients.php' ? 'active' : '' ?>" href="clients.php">
                    <i class="fas fa-users me-2"></i>
                    Clientes
                    <?php
                    try {
                        $pdo = getDbConnection();
                        $stmt = $pdo->query("SELECT COUNT(*) as count FROM clients WHERE is_active = 1");
                        $count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
                        if ($count > 0) {
                            echo '<span class="badge bg-primary rounded-pill ms-auto">' . $count . '</span>';
                        }
                    } catch (Exception $e) {
                        // Silenciar errores en sidebar
                    }
                    ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'licenses.php' ? 'active' : '' ?>" href="licenses.php">
                    <i class="fas fa-key me-2"></i>
                    Licencias
                    <?php
                    try {
                        $pdo = getDbConnection();
                        $stmt = $pdo->query("SELECT COUNT(*) as count FROM licenses WHERE status = 'Active'");
                        $count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
                        if ($count > 0) {
                            echo '<span class="badge bg-success rounded-pill ms-auto">' . $count . '</span>';
                        }
                    } catch (Exception $e) {
                        // Silenciar errores en sidebar
                    }
                    ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'logs.php' ? 'active' : '' ?>" href="logs.php">
                    <i class="fas fa-list-alt me-2"></i>
                    Logs de Verificación
                </a>
            </li>
        </ul>

        <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
            <span>Herramientas</span>
        </h6>
        <ul class="nav flex-column mb-2">
            <li class="nav-item">
                <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'test-api.php' ? 'active' : '' ?>" href="test-api.php">
                    <i class="fas fa-vial me-2"></i>
                    Probar API
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="../api/verify.php" target="_blank">
                    <i class="fas fa-external-link-alt me-2"></i>
                    Endpoint API
                    <i class="fas fa-external-link-alt ms-1" style="font-size: 0.7em;"></i>
                </a>
            </li>
        </ul>

        <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
            <span>Sistema</span>
        </h6>
        <ul class="nav flex-column mb-2">
            <li class="nav-item">
                <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'settings.php' ? 'active' : '' ?>" href="settings.php">
                    <i class="fas fa-cog me-2"></i>
                    Configuración
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'profile.php' ? 'active' : '' ?>" href="profile.php">
                    <i class="fas fa-user-edit me-2"></i>
                    Mi Perfil
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-danger" href="logout.php">
                    <i class="fas fa-sign-out-alt me-2"></i>
                    Cerrar Sesión
                </a>
            </li>
        </ul>

        <!-- Estado del sistema en sidebar -->
        <div class="px-3 mt-4">
            <div class="card border-0 bg-light">
                <div class="card-body p-2">
                    <h6 class="card-title mb-2">
                        <i class="fas fa-server me-1"></i>
                        Estado del Sistema
                    </h6>
                    <div class="d-flex justify-content-between mb-1">
                        <small>API:</small>
                        <span class="badge bg-success">Online</span>
                    </div>
                    <div class="d-flex justify-content-between mb-1">
                        <small>DB:</small>
                        <span class="badge bg-success">OK</span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <small>Versión:</small>
                        <span class="badge bg-info"><?= API_VERSION ?? '1.0' ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</nav>

<style>
    .sidebar {
        position: fixed;
        top: 76px; /* Altura del navbar */
        bottom: 0;
        left: 0;
        z-index: 100;
        padding: 0;
        box-shadow: inset -1px 0 0 rgba(0, 0, 0, 0.1);
        overflow-y: auto;
    }

    .sidebar .nav-link {
        color: #333;
        font-weight: 500;
        padding: 0.75rem 1rem;
        margin: 0 0.5rem;
        border-radius: 0.375rem;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
    }

    .sidebar .nav-link:hover {
        color: #0d6efd;
        background-color: rgba(13, 110, 253, 0.1);
    }

    .sidebar .nav-link.active {
        color: #0d6efd;
        background-color: rgba(13, 110, 253, 0.1);
        font-weight: 600;
    }

    .sidebar .nav-link.text-danger:hover {
        color: #dc3545;
        background-color: rgba(220, 53, 69, 0.1);
    }

    .sidebar-heading {
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 0.1em;
        font-weight: 600;
    }

    .badge {
        font-size: 0.6rem;
    }

    /* Responsive adjustments */
    @media (max-width: 767.98px) {
        .sidebar {
            position: static;
            height: auto;
        }
    }
</style> 